/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMMapStats;
import filenet.sim.animationdp.IVWSIMStepStats;
import filenet.sim.animationdp.impl2.StepStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class MapStats
implements IVWSIMMapStats {
    static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private Hashtable stepStats = new Hashtable(1);

    public int getMapId() {
        return this.id;
    }

    public String getMapName() {
        return this.name;
    }

    public IVWSIMStepStats[] getStepsStats() {
        return this.stepStats.values().toArray(new IVWSIMStepStats[0]);
    }

    protected String getId() {
        return Integer.toString(this.id);
    }

    public void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.id = in.readInt();
        this.name = in.readUTF();
        int count = in.readInt();
        while (count-- > 0) {
            StepStats s = new StepStats();
            s.readFromStream(in);
            this.stepStats.put(s.getId(), s);
        }
    }

    protected void merge(MapStats m) {
        for (StepStats s : m.stepStats.values()) {
            this.stepStats.put(s.getId(), s);
        }
    }

    protected int getToStringSize() {
        int size = 64;
        Iterator iter = this.stepStats.values().iterator();
        while (iter.hasNext()) {
            size += ((StepStats)iter.next()).getToStringSize();
        }
        return size;
    }

    public void toString(StringBuffer buf) {
        buf.append("\n<Map id=\"").append(this.id).append("\" name=\"").append(this.name).append("\">\n<Steps>");
        Iterator iter = this.stepStats.values().iterator();
        while (iter.hasNext()) {
            ((StepStats)iter.next()).toString(buf);
        }
        buf.append("\n</Steps></Map>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getToStringSize());
        this.toString(buf);
        return buf.toString();
    }

    public void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("MSTATS.1.0");
        out.writeInt(this.id);
        out.writeUTF(this.name);
        out.writeInt(this.stepStats.size());
        for (StepStats s : this.stepStats.values()) {
            s.writeToStream(out);
        }
    }
}

